#!/bin/bash

# Move to the directory of the script
cd "$(dirname "$0")"

# Set the directories
PROCESS_DIR="ylm2-to-process"
COMPLETED_DIR="ylm2-completed"
FAILED_DIR="ylm2-failed"

# Expand COMPLETED_DIR to a full path and store it in COMPLETED_DIR_EXPANDED
COMPLETED_DIR_EXPANDED="$(cd "${COMPLETED_DIR}" && pwd)"

echo "Starting the ylm2 file processing script..."
echo

# Create directories if they don't exist
echo "Checking if necessary directories exist..."
[ ! -d "${PROCESS_DIR}" ] && echo "Creating directory: ${PROCESS_DIR}" && mkdir "${PROCESS_DIR}"
[ ! -d "${COMPLETED_DIR}" ] && echo "Creating directory: ${COMPLETED_DIR}" && mkdir "${COMPLETED_DIR}"
[ ! -d "${FAILED_DIR}" ] && echo "Creating directory: ${FAILED_DIR}" && mkdir "${FAILED_DIR}"
echo "Directory setup complete."
echo

# Process loop
while : ; do
    echo "ylm2: Waiting for files in \"${PROCESS_DIR}\" folder to be processed..."
    # Check for files in the processing directory
    find "${PROCESS_DIR}" -type f -maxdepth 1 | while read -r file; do
        filename=$(basename -- "$file")
        # Get the absolute path of the file
        absolute_file_path="$(cd "$(dirname "$file")"; pwd -P)/$(basename "$file")"
        echo
        echo "Found file: $filename"
        echo "Processing file: $filename..."
        if ylm2 --export-type "TEXT_SUMMARY" --export-folder-path "${COMPLETED_DIR_EXPANDED}" --input-file-path "$absolute_file_path"; then
            echo "SUCCESS: File processed successfully: $filename"
            mv "$file" "${COMPLETED_DIR}/$filename"
            echo
            echo "File moved to: ${COMPLETED_DIR}"
        else
            echo "ERROR: Failed to process file: $filename"
            mv "$file" "${FAILED_DIR}/$filename"
            echo
            echo "File moved to: ${FAILED_DIR}"
        fi
        echo
    done

    # Wait for 3 seconds before checking again
    sleep 3
done
